<?php
/**
  * @version   $Id: rokgallery.php 18939 2014-02-21 23:12:05Z btowles $
  * @author    RocketTheme http://www.rockettheme.com
  * @copyright Copyright (C) 2007 - 2012 RocketTheme, LLC
  * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
  */

defined('_JEXEC') or die('Restricted index access');
jimport('joomla.plugin.plugin');
jimport('joomla.utilities.utility');

class plgSystemRokGallery extends JPlugin
{
    const NEEDED_ROKCOMMON_VERSION = '3.2.6';

	public function onAfterInitialise()
	{
		$app = JFactory::getApplication();

		if (!defined('ROKCOMMON') || !defined('ROKCOMMON_PLUGIN_LOADED')) {
			$error_string = 'RokGallery needs the RokCommon Library and Plug-in installed and enabled. The RokCommon System Plug-in needs to be before the RokGallery System Plug-in in the Plug-in Manager';
		}
		elseif (self::NEEDED_ROKCOMMON_VERSION !==  '@'.'rokcommon_version'.'@' && !preg_match('/project.version/',ROKCOMMON) && version_compare(ROKCOMMON, self::NEEDED_ROKCOMMON_VERSION, '<'))
		{
			$error_string = sprintf('RokGallery needs at least RokCommon version %s.  You currently have RokCommon version %s', self::NEEDED_ROKCOMMON_VERSION, ROKCOMMON);
		}
		if (!empty($error_string))
		{
			if (JError::$legacy) {
				return JError::raiseWarning(500, $error_string);
			} else {
				$app->enqueueMessage($error_string, 'warning');
				return;
			}
		}
		define('ROKGALLERY', '2.45');

	}

	function onBeforeCompileHead()
    {
        $version = new JVersion();

        if ($version->getShortVersion() < '1.5.23')
            return;

        $option = JFactory::getApplication()->input->getCmd('option');
        $view = JFactory::getApplication()->input->getCmd('view');
        $app = JFactory::getApplication();

        if ($option == 'com_rokgallery' && $view == 'gallerypicker' && $app->isSite()){
            $this->_cleanView();
		}
	}

    function _cleanView()
    {
        $path = (JFactory::getApplication()->isSite()) ? JPATH_COMPONENT_ADMINISTRATOR : JPATH_COMPONENT;
        require_once ($path.'/helpers/rokgallery.php');

        RokGalleryHelper::setupGalleryPicker();

		return true;
    }
}
