<?php

/**
 * RokGallery_Model_SliceTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class RokGallery_Model_SliceTable extends RokCommon_Doctrine_Table
{
    /**
     * Returns an instance of this class.
     *
     * @return object RokGallery_Model_SliceTable
     */
    public static function getInstance()
    {
        return Doctrine_Core::getTable('RokGallery_Model_Slice');
    }


	/**
	 * @static
	 *
	 * @param $id
	 *
	 * @throws #C\Exception|?
	 * @return \RokGallery_Model_Slice
	 */
    public static function getSingle($id)
    {
        try
        {
            $table = self::getInstance();
            return $table->find($id);
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

	/**
	 * @param      $tag
	 * @param bool $publishedOnly
	 * @param bool $exclude_admin_thumbs
	 *
	 * @throws #C\Exception|?
	 * @return bool|\Doctrine_Collection
	 */
    public static function getByTag($tag, $publishedOnly = true, $exclude_admin_thumbs = true)
    {
        try
        {
            if (null == $tag) return array();
            $table = self::getInstance();
            $q = $table->createQuery('s')
                    ->leftJoin('s.Tags t')
                    ->leftJoin('s.FileTags ft')
                    ->where('t.tag = ?', $tag)
                    ->orWhere('ft.tag = ?', $tag);
            if ($exclude_admin_thumbs) {
                $q->andWhere('s.admin_thumb = ?', false);
            }
            if ($publishedOnly) {
                $q->andWhere('s.published = ?', true);
            }

            $return = $q->execute();
            $q->free();
            return $return;
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

	/**
	 * @param \array() $tags array()
	 * @param bool     $publishedOnly
	 * @param bool     $exclude_admin_thumbs
	 *
	 * @throws #C\Exception|?
	 * @return bool|\Doctrine_Collection
	 */
    public static function getByTags($tags, $publishedOnly = true, $exclude_admin_thumbs = true)
    {
        try
        {
            if (null == $tags) return array();
            $table = self::getInstance();
            $q = $table->createQuery('s')
                    ->leftJoin('s.Tags t')
                    ->leftJoin('s.FileTags ft')
                    ->whereIn('t.tag', $tags)
                    ->orWhereIn('ft.tag', $tags);
            if ($exclude_admin_thumbs) {
                $q->andWhere('s.admin_thumb = ?', false);
            }
            if ($publishedOnly) {
                $q->andWhere('s.published = ?', true);
            }

            $return = $q->execute();
            $q->free();
            return $return;
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

	/**
	 * @param \array() $ids array()
	 * @param bool     $publishedOnly
	 * @param bool     $exclude_admin_thumbs
	 * @throws #C\Exception|?
	 * @return bool|\Doctrine_Collection
	 */
    public static function getByGalleryIds($ids, $publishedOnly = true, $exclude_admin_thumbs = true)
    {
        try
        {
            if (null == $ids) return array();
            $table = self::getInstance();
            $q = $table->createQuery('s')
                    ->whereIn('s.gallery_id', $ids);
            if ($exclude_admin_thumbs) {
                $q->andWhere('s.admin_thumb = ?', false);
            }
            if ($publishedOnly) {
                $q->andWhere('s.published = ?', true);
            }

            $return = $q->execute();
            $q->free();
            return $return;
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

	/**
	 * @param      $tag
	 * @param bool $publishedOnly
	 * @param bool $exclude_admin_thumbs
	 * @throws #C\Exception|?
	 * @return \int[]
	 */
    public static function getIdsByTag($tag, $publishedOnly = true, $exclude_admin_thumbs = true)
    {
        try
        {
            if (null == $tag) return array();

            $table = self::getInstance();

            $q = $table->createQuery('s')
                    ->select('s.id')
                    ->leftJoin('s.Tags t')
                    ->leftJoin('s.FileTags ft')
                    ->where('t.tag = ?', $tag)
                    ->orWhere('ft.tag = ?', $tag);
            if ($publishedOnly) {
                $q->andWhere('s.published = ?', true);
            }
            $return = $q->execute(array(), Doctrine_Core::HYDRATE_SCALAR);
            $q->free();
            if (!is_array($return)) {
                $return = array($return);
            }
            return $return;
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

}