<?php

/**
 * RokGallery_Model_GalleryTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class RokGallery_Model_GalleryTable extends RokCommon_Doctrine_Table
{
    /**
     * Returns an instance of this class.
     *
     * @return object RokGallery_Model_GalleryTable
     */
    public static function getInstance()
    {
        return Doctrine_Core::getTable('RokGallery_Model_Gallery');
    }

    /**
     * @static
     * @throws Exception
     * @param  $id
     * @return RokGallery_Model_Gallery
     */
    public static function getSingle($id)
    {
        try
        {
            $table = self::getInstance();
            $q = $table->createQuery('f')
                    ->where('f.id = ?', $id);
            $ret = $q->fetchOne();
            $q->free();
            return $ret;
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

    public static function getAll()
    {
        try
        {
            $table = self::getInstance();
            $q = $table->createQuery('g')
                    ->orderBy('g.name');
            $ret = $q->execute();
            $q->free();
            return $ret;
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

    /**
     * @static
     * @throws Exception
     * @param $tag
     * @return RokGallery_Model_Gallery
     */
    public static function getByTag($tag)
    {
        try
        {
            $ret = array();
            $galleries = self::getAll();
            foreach($galleries as $gallery){
                if (in_array($tag, $gallery->filetags))
                {
                    $ret[] = $gallery;
                }
            }
            return $ret;
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

    /**
     * @static
     * @throws Exception
     * @param $name
     * @return RokGallery_Model_Gallery
     */
    public static function getByName($name)
    {
        try
        {
            $table = self::getInstance();
            $q = $table->createQuery('g')
                    ->where('g.name = ?', $name);
            $ret = $q->fetchOne();
            $q->free();
            return $ret;
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

    /**
     * @param array $sliceIds
     */
    public static function deleteSlices(array $sliceIds)
    {
        try
        {
            if (empty($sliceIds) || null == $sliceIds) return;

            $q = Doctrine_Query::create()
                    ->delete('RokGallery_Model_Slice s')
                    ->whereIn('s.id', $sliceIds);
            $ret = $q->execute();
            $q->free();
            return;
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

    /**
     * @param array $sliceIds
     */
    public static function unlinkSlices(array $sliceIds)
    {
        try
        {
            if (empty($sliceIds) || null == $sliceIds) return;
            $q = Doctrine_Query::create()
                    ->update('RokGallery_Model_Slice s')
                    ->set('s.gallery_id', '?', null)
                    ->whereIn('s.id', $sliceIds);

            $ret = $q->execute();
            $q->free();
            return;
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

    /**
     * @param array $sliceIds
     */
    public static function publishSlices($gallery_id)
    {
        try
        {
            if (empty($gallery_id) || null == $gallery_id) return;

            $q = Doctrine_Query::create()
                    ->update('RokGallery_Model_Slice s')
                    ->set('s.published', '?', true)
                    ->where('s.gallery_id = ?', $gallery_id);
            $ret = $q->execute();
            $q->free();
            return $ret;
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }
}