<?php

/**
 * RokGallery_Model_Base_Slice
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $id
 * @property integer $file_id
 * @property integer $gallery_id
 * @property char $guid
 * @property string $title
 * @property string $caption
 * @property string $link
 * @property integer $filesize
 * @property integer $xsize
 * @property integer $ysize
 * @property integer $thumb_xsize
 * @property integer $thumb_ysize
 * @property boolean $thumb_keep_aspect
 * @property string $thumb_background
 * @property boolean $published
 * @property boolean $admin_thumb
 * @property object $manipulations
 * @property string $palette
 * @property RokGallery_Model_File $File
 * @property Doctrine_Collection $Tags
 * @property Doctrine_Collection $FileTags
 * @property RokGallery_Model_Gallery $Gallery
 * 
 * @package    RokGallery
 * @subpackage models
 * @author     RocketTheme LLC <support@rockettheme.com>
 * @version    SVN: $Id: Slice.php 10871 2013-05-30 04:06:26Z btowles $
 */
abstract class RokGallery_Model_Base_Slice extends RokCommon_Doctrine_Record
{
    public function setTableDefinition()
    {
        $this->setTableName('rokgallery_slices');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => true,
             'primary' => true,
             'unique' => true,
             'autoincrement' => true,
             'length' => '4',
             ));
        $this->hasColumn('file_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => true,
             'notnull' => true,
             'length' => '4',
             ));
        $this->hasColumn('gallery_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => true,
             'length' => '4',
             ));
        $this->hasColumn('guid', 'char', 36, array(
             'type' => 'char',
             'notnull' => true,
             'unique' => true,
             'length' => '36',
             ));
        $this->hasColumn('title', 'string', 200, array(
             'type' => 'string',
             'length' => '200',
             ));
        $this->hasColumn('caption', 'string', null, array(
             'type' => 'string',
             'length' => '',
             ));
        $this->hasColumn('link', 'string', 256, array(
             'type' => 'string',
             'length' => '256',
             ));
        $this->hasColumn('filesize', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => true,
             'notnull' => true,
             'length' => '4',
             ));
        $this->hasColumn('xsize', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => true,
             'notnull' => true,
             'length' => '4',
             ));
        $this->hasColumn('ysize', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => true,
             'notnull' => true,
             'length' => '4',
             ));
        $this->hasColumn('thumb_xsize', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => true,
             'notnull' => true,
             'length' => '4',
             ));
        $this->hasColumn('thumb_ysize', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => true,
             'notnull' => true,
             'length' => '4',
             ));
        $this->hasColumn('thumb_keep_aspect', 'boolean', null, array(
             'type' => 'boolean',
             'notnull' => true,
             'default' => 1,
             ));
        $this->hasColumn('thumb_background', 'string', 12, array(
             'type' => 'string',
             'length' => '12',
             ));
        $this->hasColumn('published', 'boolean', null, array(
             'type' => 'boolean',
             'default' => 0,
             'notnull' => true,
             ));
        $this->hasColumn('admin_thumb', 'boolean', null, array(
             'type' => 'boolean',
             'notnull' => true,
             'default' => 0,
             ));
        $this->hasColumn('manipulations', 'object', null, array(
             'type' => 'object',
             ));
        $this->hasColumn('palette', 'string', null, array(
             'type' => 'string',
             'length' => '',
             ));


        $this->index('rokgallery_slices_published', array(
             'fields' => 
             array(
              0 => 'published',
             ),
             ));
        $this->index('rokgallery_slices_guid', array(
             'fields' => 
             array(
              0 => 'guid',
             ),
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('RokGallery_Model_File as File', array(
             'local' => 'file_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE',
             'onUpdate' => 'CASCADE'));

        $this->hasMany('RokGallery_Model_SliceTags as Tags', array(
             'local' => 'id',
             'foreign' => 'slice_id'));

        $this->hasMany('RokGallery_Model_FileTags as FileTags', array(
             'local' => 'file_id',
             'foreign' => 'file_id',
             'onDelete' => 'NO ACTION',
             'onUpdate' => 'NO ACTION'));

        $this->hasOne('RokGallery_Model_Gallery as Gallery', array(
             'local' => 'gallery_id',
             'foreign' => 'id',
             'onDelete' => 'SET NULL',
             'onUpdate' => 'CASCADE'));

        $orderable0 = new Doctrine_Template_Orderable(array(
             'orderableBy' => 
             array(
              0 => 'gallery_id',
             ),
             ));
        $timestampable0 = new Doctrine_Template_Timestampable();
        $sluggable0 = new Doctrine_Template_Sluggable(array(
             'fields' => 
             array(
              0 => 'title',
             ),
             'uniqueBy' => 
             array(
              0 => 'gallery_id',
             ),
             'unique' => true,
             ));
        $searchable0 = new Doctrine_Template_Searchable(array(
             'fields' => 
             array(
              0 => 'title',
              1 => 'caption',
             ),
             'tableName' => '%TABLE%_index',
             'builderOptions' => 
             array(
              'baseClassName' => 'RokCommon_Doctrine_Record',
              'baseTableClassName' => 'RokCommon_Doctrine_Table',
             ),
             ));
        $this->actAs($orderable0);
        $this->actAs($timestampable0);
        $this->actAs($sluggable0);
        $this->actAs($searchable0);
    }
}